/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.enchant;

import com.lothrazar.cyclic.config.ConfigRegistry;
import com.lothrazar.cyclic.enchant.EnchantmentCyclic;
import com.lothrazar.cyclic.util.UtilItemStack;
import com.lothrazar.cyclic.util.UtilNBT;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;

public class BeheadingEnchant
extends EnchantmentCyclic {
    public static final int PERCDROP = 20;
    public static final int PERCPERLEVEL = 25;
    public static final String ID = "beheading";
    public static ForgeConfigSpec.BooleanValue CFG;

    public BeheadingEnchant(Enchantment.Rarity rarityIn, EnchantmentCategory typeIn, EquipmentSlot ... slots) {
        super(rarityIn, typeIn, slots);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)CFG.get();
    }

    public int m_6586_() {
        return 3;
    }

    private int percentForLevel(int level) {
        return 20 + (level - 1) * 25;
    }

    @SubscribeEvent
    public void onEntityKill(LivingDeathEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        if (event.getSource().m_7639_() instanceof Player) {
            Player attacker = (Player)event.getSource().m_7639_();
            int level = this.getCurrentLevelTool((LivingEntity)attacker);
            if (level <= 0) {
                return;
            }
            Level world = attacker.f_19853_;
            if (Mth.m_14072_((Random)world.f_46441_, (int)0, (int)100) > this.percentForLevel(level)) {
                return;
            }
            LivingEntity target = (LivingEntity)event.getEntity();
            if (target == null) {
                return;
            }
            BlockPos pos = target.m_142538_();
            if (target instanceof Player) {
                UtilItemStack.drop(world, pos, UtilNBT.buildNamedPlayerSkull((Player)target));
                return;
            }
            String key = target.m_6095_().getRegistryName().toString();
            Map<String, String> mappedBeheading = ConfigRegistry.getMappedBeheading();
            if (target.m_6095_() == EntityType.f_20565_) {
                UtilItemStack.drop(world, pos, new ItemStack((ItemLike)Items.f_42683_));
            } else if (target.m_6095_() == EntityType.f_20558_) {
                UtilItemStack.drop(world, pos, new ItemStack((ItemLike)Items.f_42682_));
            } else if (target.m_6095_() == EntityType.f_20501_) {
                UtilItemStack.drop(world, pos, new ItemStack((ItemLike)Items.f_42681_));
            } else if (target.m_6095_() == EntityType.f_20524_) {
                UtilItemStack.drop(world, pos, new ItemStack((ItemLike)Items.f_42678_));
            } else if (target.m_6095_() == EntityType.f_20497_) {
                UtilItemStack.drop(world, pos, new ItemStack((ItemLike)Items.f_42679_));
            } else if (target.m_6095_() == EntityType.f_20496_) {
                UtilItemStack.drop(world, pos, new ItemStack((ItemLike)Items.f_42679_, Math.max(level, 3)));
            } else if (ModList.get().isLoaded("tconstruct")) {
                String id = "tconstruct";
                ItemStack tFound = ItemStack.f_41583_;
                if (target.m_6095_() == EntityType.f_20562_) {
                    tFound = UtilItemStack.findItem(id + ":drowned_head");
                } else if (target.m_6095_() == EntityType.f_20458_) {
                    tFound = UtilItemStack.findItem(id + ":husk_head");
                } else if (target.m_6095_() == EntityType.f_20566_) {
                    tFound = UtilItemStack.findItem(id + ":enderman_head");
                } else if (target.m_6095_() == EntityType.f_20479_) {
                    tFound = UtilItemStack.findItem(id + ":spider_head");
                } else if (target.m_6095_() == EntityType.f_20554_) {
                    tFound = UtilItemStack.findItem(id + ":cave_spider_head");
                } else if (target.m_6095_() == EntityType.f_20481_) {
                    tFound = UtilItemStack.findItem(id + ":stray_head");
                } else if (target.m_6095_() == EntityType.f_20551_) {
                    tFound = UtilItemStack.findItem(id + ":blaze_head");
                }
                if (!tFound.m_41619_()) {
                    UtilItemStack.drop(world, pos, tFound);
                    return;
                }
            } else if (mappedBeheading.containsKey(key)) {
                UtilItemStack.drop(world, pos, UtilNBT.buildNamedPlayerSkull(mappedBeheading.get(key)));
            }
        }
    }
}

